"""empty message

Revision ID: ca03ba18f2c0
Revises: None
Create Date: 2016-05-19 14:27:49.945534

"""

# revision identifiers, used by Alembic.
revision = 'ca03ba18f2c0'
down_revision = None

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.create_table('tb_acl_object_class',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('object_class', sa.String(length=100), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_acl_object_class')),
    sa.UniqueConstraint('object_class', name=op.f('uq_tb_acl_object_class_object_class'))
    )
    op.create_table('tb_app_locks',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_app_locks')),
    sa.UniqueConstraint('name', name=op.f('uq_tb_app_locks_name'))
    )
    op.create_table('tb_audit_log',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('event_type', sa.Integer(), nullable=False),
    sa.Column('event_id', sa.Integer(), nullable=False),
    sa.Column('severity', sa.Integer(), nullable=False),
    sa.Column('event_source', sa.Integer(), nullable=False),
    sa.Column('action_by', sa.Text(), nullable=True),
    sa.Column('from_ip', postgresql.INET(), nullable=True),
    sa.Column('result', sa.Integer(), nullable=False),
    sa.Column('description', sa.Text(), nullable=True),
    sa.Column('log_utc_time', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_audit_log'))
    )
    op.create_table('tb_deployment_plan',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('plan_id', sa.String(length=36), nullable=False),
    sa.Column('display_name', sa.String(length=256), nullable=True),
    sa.Column('description', sa.String(), nullable=True),
    sa.Column('creation_time_in_utc', sa.DateTime(), nullable=True),
    sa.Column('last_update_time_in_utc', sa.DateTime(), nullable=True),
    sa.Column('creator', sa.BigInteger(), nullable=True),
    sa.Column('enabler', sa.BigInteger(), nullable=True),
    sa.Column('last_modifier', sa.BigInteger(), nullable=True),
    sa.Column('creator_display_name', sa.String(), nullable=True),
    sa.Column('enabler_display_name', sa.String(), nullable=True),
    sa.Column('last_modifier_display_name', sa.String(), nullable=True),
    sa.Column('enabled', sa.Integer(), nullable=True),
    sa.Column('is_immediately', sa.Integer(), nullable=True),
    sa.Column('offhour_enabled', sa.Integer(), nullable=False),
    sa.Column('package_type', sa.BigInteger(), nullable=True),
    sa.Column('package_id', sa.BigInteger(), nullable=True),
    sa.Column('package_checksum', sa.String(), nullable=True),
    sa.Column('package_meta', postgresql.JSON(), nullable=True),
    sa.Column('deploy_by_device_time', sa.Integer(), nullable=True),
    sa.Column('triggered_server_time_in_utc', sa.DateTime(), nullable=True),
    sa.Column('expired_in_days', sa.Integer(), nullable=True),
    sa.Column('device_time_deploy_period_from', sa.Integer(), nullable=True),
    sa.Column('device_time_deploy_period_to', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_deployment_plan')),
    sa.UniqueConstraint('display_name', name=op.f('uq_tb_deployment_plan_display_name')),
    sa.UniqueConstraint('id', name=op.f('uq_tb_deployment_plan_id')),
    sa.UniqueConstraint('plan_id', name=op.f('uq_tb_deployment_plan_plan_id'))
    )
    op.create_table('tb_deployment_resource',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('package_type', sa.Integer(), nullable=True),
    sa.Column('supported_product_version', sa.String(), nullable=True),
    sa.Column('package_name', sa.String(), nullable=True),
    sa.Column('description', sa.String(), nullable=True),
    sa.Column('package_size', sa.Integer(), nullable=True),
    sa.Column('uploaded_time_in_utc', sa.DateTime(), nullable=True),
    sa.Column('uploader', sa.String(), nullable=True),
    sa.Column('physical_path', sa.String(), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_deployment_resource'))
    )
    op.create_table('tb_device_cluster_info',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('slave_guid', sa.String(length=36), nullable=True),
    sa.Column('master_guid', sa.String(length=36), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_device_cluster_info')),
    sa.UniqueConstraint('slave_guid', name=op.f('uq_tb_device_cluster_info_slave_guid'))
    )
    op.create_table('tb_features',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('feature_identity', sa.String(length=256), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_features')),
    sa.UniqueConstraint('feature_identity', name=op.f('uq_tb_features_feature_identity'))
    )
    op.create_table('tb_local_repo_device_binding',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('device_guid', sa.String(length=36), nullable=False),
    sa.Column('local_repo_guid', sa.String(length=36), nullable=False),
    sa.Column('priority', sa.Integer(), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_local_repo_device_binding')),
    sa.UniqueConstraint('device_guid', 'local_repo_guid', name='uq_tb_local_repo_device_binding_device_guid_local_repo_guid'),
    sa.UniqueConstraint('device_guid', 'priority', name='uq_tb_local_repo_device_binding_device_guid_priority')
    )
    op.create_table('tb_resources',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('resource_type', sa.Integer(), nullable=False),
    sa.Column('severity', sa.Integer(), nullable=False),
    sa.Column('product_type', sa.Integer(), nullable=False),
    sa.Column('version', sa.String(), nullable=True),
    sa.Column('language', sa.Integer(), nullable=True),
    sa.Column('archive_name', sa.String(), nullable=False),
    sa.Column('file_name', sa.String(), nullable=False),
    sa.Column('file_path', sa.String(), nullable=False),
    sa.Column('file_size', sa.BigInteger(), nullable=False),
    sa.Column('archive_size', sa.BigInteger(), nullable=False),
    sa.Column('chunk_size', sa.BigInteger(), nullable=False),
    sa.Column('checksum', sa.String(), nullable=False),
    sa.Column('chunk_checksum', postgresql.ARRAY(sa.String()), nullable=False),
    sa.Column('meta', sa.String(), nullable=True),
    sa.Column('description', sa.String(), nullable=True),
    sa.Column('source_info', postgresql.JSON(), nullable=True),
    sa.Column('creator', sa.BigInteger(), nullable=True),
    sa.Column('create_time', sa.DateTime(timezone=True), nullable=False),
    sa.Column('modify_time', sa.DateTime(timezone=True), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_resources')),
    sa.UniqueConstraint('checksum', name=op.f('uq_tb_resources_checksum'))
    )
    op.create_table('tb_roles',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('role_name', sa.String(length=100), nullable=False),
    sa.Column('description', sa.String(length=512), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_roles')),
    sa.UniqueConstraint('role_name', name=op.f('uq_tb_roles_role_name'))
    )
    op.create_table('tb_session',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('session_id', sa.String(length=256), nullable=True),
    sa.Column('data', sa.Text(), nullable=True),
    sa.Column('expiry', sa.DateTime(), nullable=True),
    sa.Column('user_id', sa.BigInteger(), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_session')),
    sa.UniqueConstraint('session_id', name=op.f('uq_tb_session_session_id'))
    )
    op.create_table('tb_system_node',
    sa.Column('guid', sa.String(length=36), nullable=False),
    sa.Column('type_', sa.Integer(), nullable=False),
    sa.PrimaryKeyConstraint('guid', name=op.f('pk_tb_system_node')),
    sa.UniqueConstraint('guid', name=op.f('uq_tb_system_node_guid')),
    sa.UniqueConstraint('type_', name=op.f('uq_tb_system_node_type_'))
    )
    op.create_table('tb_system_settings',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('key', sa.String(length=50), nullable=True),
    sa.Column('value', sa.String(), nullable=True),
    sa.Column('created_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('modified_time', sa.DateTime(timezone=True), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_system_settings')),
    sa.UniqueConstraint('key', name=op.f('uq_tb_system_settings_key'))
    )
    op.create_table('tb_tree_node',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('guid', sa.String(length=36), nullable=False),
    sa.Column('parent_guid', sa.String(length=36), nullable=True),
    sa.Column('type_', sa.Integer(), nullable=True),
    sa.Column('product_type', sa.Integer(), nullable=True),
    sa.Column('device_type', sa.Integer(), nullable=True),
    sa.Column('display_name', sa.Unicode(length=256), nullable=True),
    sa.Column('state', sa.String(), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_tree_node')),
    sa.UniqueConstraint('guid', name=op.f('uq_tb_tree_node_guid'))
    )
    op.create_table('tb_updates',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('package_name', sa.String(), nullable=False),
    sa.Column('package_type', sa.Integer(), nullable=False),
    sa.Column('package_severity', sa.Integer(), nullable=False),
    sa.Column('version', sa.String(), nullable=False),
    sa.Column('action', sa.Integer(), nullable=False),
    sa.Column('agent_task_id', sa.String(), nullable=True),
    sa.Column('completed_date', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_updates'))
    )
    op.create_table('tb_user_profile',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('guid', postgresql.UUID(), nullable=False),
    sa.Column('user_id', sa.BigInteger(), nullable=True),
    sa.Column('feature', sa.String(length=100), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_user_profile')),
    sa.UniqueConstraint('guid', name=op.f('uq_tb_user_profile_guid'))
    )
    op.create_table('tb_users',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('username', sa.String(length=100), nullable=True),
    sa.Column('password', sa.LargeBinary(length=120), nullable=True),
    sa.Column('salt', sa.String(length=120), nullable=True),
    sa.Column('type', sa.Integer(), nullable=True),
    sa.Column('is_active', sa.Boolean(), nullable=True),
    sa.Column('is_locked', sa.Boolean(), nullable=True),
    sa.Column('description', sa.String(length=512), nullable=True),
    sa.Column('login_fail_count', sa.Integer(), nullable=True),
    sa.Column('last_login_fail_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('created_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('modified_time', sa.DateTime(timezone=True), nullable=True),
    sa.Column('last_login_time', sa.DateTime(timezone=True), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_users')),
    sa.UniqueConstraint('username', name=op.f('uq_tb_users_username'))
    )
    op.create_table('tb_acl_object_identity',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('object_class_id', sa.BigInteger(), nullable=False),
    sa.Column('object_id', sa.String(length=36), nullable=False),
    sa.ForeignKeyConstraint(['object_class_id'], ['tb_acl_object_class.id'], name=op.f('fk_tb_acl_object_identity_object_class_id_tb_acl_object_class')),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_acl_object_identity')),
    sa.UniqueConstraint('object_class_id', 'object_id', name=op.f('uq_tb_acl_object_identity_object_class_id'))
    )
    op.create_table('tb_deployment_plan_task',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('plan_id', sa.String(length=36), nullable=True),
    sa.Column('target', sa.String(length=36), nullable=True),
    sa.Column('folder_path', sa.String(), nullable=True),
    sa.Column('task_start_time_in_utc', sa.DateTime(), nullable=True),
    sa.Column('last_update_time_in_utc', sa.DateTime(), nullable=True),
    sa.Column('task_status', sa.String(), nullable=True),
    sa.Column('task_sub_status', sa.String(), nullable=True),
    sa.Column('task_status_message', sa.String(), nullable=True),
    sa.ForeignKeyConstraint(['plan_id'], ['tb_deployment_plan.plan_id'], name=op.f('fk_tb_deployment_plan_task_plan_id_tb_deployment_plan')),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_deployment_plan_task')),
    sa.UniqueConstraint('plan_id', 'target', name=op.f('uq_tb_deployment_plan_task_plan_id'))
    )
    op.create_table('tb_device_info',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('guid', sa.String(length=36), nullable=True),
    sa.Column('host_name', sa.String(length=256), nullable=True),
    sa.Column('device_ips', postgresql.ARRAY(postgresql.INET()), nullable=True),
    sa.Column('product_type', sa.Integer(), nullable=True),
    sa.Column('product_version', sa.String(length=19), nullable=True),
    sa.Column('product_language', sa.Integer(), nullable=True),
    sa.Column('agent_version', sa.String(length=19), nullable=True),
    sa.Column('product_localtime_in_utc', sa.DateTime(), nullable=True),
    sa.Column('timezone_in_mins', sa.Integer(), nullable=True),
    sa.Column('daylight_saving_in_mins', sa.Integer(), nullable=True),
    sa.Column('parent_id', sa.String(length=36), nullable=True),
    sa.Column('last_update_time', sa.DateTime(), nullable=True),
    sa.Column('registration_time', sa.DateTime(), nullable=True),
    sa.Column('local_repository_url', sa.String(), nullable=True),
    sa.Column('root_repository_sync', postgresql.JSON(), nullable=True),
    sa.Column('offhour_begin', sa.Integer(), nullable=True),
    sa.Column('offhour_end', sa.Integer(), nullable=True),
    sa.Column('components_info', postgresql.JSON(), nullable=True),
    sa.ForeignKeyConstraint(['guid'], ['tb_tree_node.guid'], name=op.f('fk_tb_device_info_guid_tb_tree_node')),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_device_info')),
    sa.UniqueConstraint('guid', name=op.f('uq_tb_device_info_guid'))
    )
    op.create_table('tb_download_tasks',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('resource_id', sa.BigInteger(), nullable=False),
    sa.Column('chunk_index', sa.Integer(), nullable=False),
    sa.Column('status', sa.Integer(), nullable=False),
    sa.Column('create_time', sa.DateTime(timezone=True), nullable=False),
    sa.Column('modify_time', sa.DateTime(timezone=True), nullable=False),
    sa.ForeignKeyConstraint(['resource_id'], ['tb_resources.id'], name=op.f('fk_tb_download_tasks_resource_id_tb_resources')),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_download_tasks'))
    )
    op.create_table('tb_user_role',
    sa.Column('user_id', sa.BigInteger(), nullable=False),
    sa.Column('role_id', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['role_id'], ['tb_roles.id'], name=op.f('fk_tb_user_role_role_id_tb_roles')),
    sa.ForeignKeyConstraint(['user_id'], ['tb_users.id'], name=op.f('fk_tb_user_role_user_id_tb_users')),
    sa.PrimaryKeyConstraint('user_id', 'role_id', name=op.f('pk_tb_user_role'))
    )
    op.create_table('tb_acl_entry',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('object_identity_id', sa.BigInteger(), nullable=False),
    sa.Column('role_id', sa.BigInteger(), nullable=False),
    sa.Column('action', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['object_identity_id'], ['tb_acl_object_identity.id'], name=op.f('fk_tb_acl_entry_object_identity_id_tb_acl_object_identity')),
    sa.ForeignKeyConstraint(['role_id'], ['tb_roles.id'], name=op.f('fk_tb_acl_entry_role_id_tb_roles')),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_acl_entry')),
    sa.UniqueConstraint('object_identity_id', 'role_id', 'action', name=op.f('uq_tb_acl_entry_object_identity_id'))
    )
    ### end Alembic commands ###


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('tb_acl_entry')
    op.drop_table('tb_user_role')
    op.drop_table('tb_download_tasks')
    op.drop_table('tb_device_info')
    op.drop_table('tb_deployment_plan_task')
    op.drop_table('tb_acl_object_identity')
    op.drop_table('tb_users')
    op.drop_table('tb_user_profile')
    op.drop_table('tb_updates')
    op.drop_table('tb_tree_node')
    op.drop_table('tb_system_settings')
    op.drop_table('tb_system_node')
    op.drop_table('tb_session')
    op.drop_table('tb_roles')
    op.drop_table('tb_resources')
    op.drop_table('tb_local_repo_device_binding')
    op.drop_table('tb_features')
    op.drop_table('tb_device_cluster_info')
    op.drop_table('tb_deployment_resource')
    op.drop_table('tb_deployment_plan')
    op.drop_table('tb_audit_log')
    op.drop_table('tb_app_locks')
    op.drop_table('tb_acl_object_class')
    ### end Alembic commands ###
